"""
HB_BrushStrengthDecrease V1.1

Last Modified: Oct/01/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_BrushStrengthDecrease
Description-US: Decrease the strength of Tools and Objects

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=34m5s

Usage:
This Script works with several Tools and Objects.


ChangeLog:
Jun/11/2015 V1.0
- Release Version

Oct/01/2018 V1.1
- Python Rewrite
- Code Optimization
- New Highres Icon


"""

import c4d
from c4d import documents, plugins
  
def tool():
        return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)
    
def main():
    
    Factor=0.8
    SelObj=doc.GetActiveObject()
    Tool_ID=doc.GetAction()           
    
    #BrushTool
    if Tool_ID==1016202:
 
        tool()[c4d.MDATA_BRUSH_FALLOFF_STRENGTH]=tool()[c4d.MDATA_BRUSH_FALLOFF_STRENGTH]*Factor
    

    
    #SoftSelection
    if Tool_ID==200000088 or Tool_ID==200000089 or Tool_ID==200000090 :

        if tool()[c4d.MDATA_SOFT_ENABLE]:
       
            tool()[c4d.MDATA_SOFT_STRENGTH]=float(tool()[c4d.MDATA_SOFT_STRENGTH])*Factor
        
    #MagnetTool
    if Tool_ID==1016185:
        tool()[c4d.MDATA_MAGNET_FALLOFF_STRENGTH]=tool()[c4d.MDATA_MAGNET_FALLOFF_STRENGTH]*Factor
    
    
    #PaintTool
    if Tool_ID==1021286:
        tool()[c4d.ID_CA_PAINT_TOOL_OPACITY]=tool()[c4d.ID_CA_PAINT_TOOL_OPACITY]*Factor

    

    #WeightTool
    if Tool_ID==1019499:
        tool()[c4d.ID_CA_WEIGHT_TOOL_STRENGTH]=tool()[c4d.ID_CA_WEIGHT_TOOL_STRENGTH]*Factor
        
    #DoodleTool
    if Tool_ID==1022257:
  
        tool()[c4d.MDATA_DOODLE_OPACITY]=tool()[c4d.MDATA_DOODLE_OPACITY]*Factor
    

    #DoodleEraser
    if Tool_ID==1022286:
        tool()[c4d.MDATA_DOODLE_OPACITY]=tool()[c4d.MDATA_DOODLE_OPACITY]*Factor        
    

   
        

if __name__=='__main__':
    main()
    c4d.EventAdd()
